import ast
import sys

SCRIPT_NAME = f"{sys._getframe().f_code.co_filename}"

def create_function_list(filename, prefix =""):
    #
    filename += ".py" 
    with open(filename, 'r') as file:
        tree = ast.parse(file.read(), filename=filename)

    function_names = [node.name for node in ast.walk(tree) if isinstance(node, ast.FunctionDef)]   
    list_name = filename.replace(".py", ".fun")

    with open(list_name, 'w') as file:
        for f in function_names:
            file.write(prefix + f + '\n')
    
    return(list_name)

# Example usage:
if __name__ == '__main__':
    # prefix = os.path.abspath(__file__) + '\\'
    prefix = "fleming.module_test."
    script = input('Scriptname (w/o .py): ')
    listfile = create_function_list(script, prefix) 
    print(listfile)